/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.ArrayList;
import java.util.List;
import mcinterface1201.BuilderBlockTileEntity;
import mcinterface1201.PacketEntityCSHandshakeClient;
import mcinterface1201.PacketEntityCSHandshakeServer;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BuilderTileEntity
extends BlockEntity {
    protected static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"mts");
    protected static RegistryObject<BlockEntityType<BuilderTileEntity>> TE_TYPE;
    protected ATileEntityBase<?> tileEntity;
    private boolean needDataFromServer = true;
    protected CompoundTag lastLoadedNBT;
    protected boolean loadFromSavedNBT;
    protected boolean loadedFromSavedNBT;
    protected final List<IWrapperPlayer> playersRequestingData = new ArrayList<IWrapperPlayer>();
    private int lastLightValue = 0;

    public BuilderTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TE_TYPE.get(), pos, state);
    }

    public BuilderTileEntity(BlockEntityType<?> teType, BlockPos pos, BlockState state) {
        super(teType, pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null && this.f_58858_ != null) {
            if (this.tileEntity != null) {
                int lightValue = (int)(this.tileEntity.getLightProvided() * 15.0f);
                if (lightValue != this.lastLightValue) {
                    this.lastLightValue = lightValue;
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BuilderBlockTileEntity.LIGHT, (Comparable)Integer.valueOf(lightValue)), 3);
                }
                if (this.tileEntity.hasChanged) {
                    this.m_6596_();
                    this.tileEntity.hasChanged = false;
                }
            } else if (!this.loadedFromSavedNBT) {
                if (this.lastLoadedNBT != null && !this.f_58857_.f_46443_) {
                    this.loadFromSavedNBT = true;
                }
                if (this.loadFromSavedNBT && this.f_58857_.m_46749_(this.f_58858_)) {
                    try {
                        WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.f_58857_);
                        Point3D position = new Point3D(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
                        ABlockBaseTileEntity block = (ABlockBaseTileEntity)worldWrapper.getBlock(position);
                        WrapperNBT data = new WrapperNBT(this.lastLoadedNBT);
                        this.setTileEntity(block.createTileEntity(worldWrapper, position, null, (AItemSubTyped)data.getPackItem(), data));
                        this.tileEntity.world.addEntity(this.tileEntity);
                        this.f_58857_.m_151543_(this.f_58858_);
                        this.loadedFromSavedNBT = true;
                        this.lastLoadedNBT = null;
                    }
                    catch (Exception e) {
                        InterfaceManager.coreInterface.logError("Failed to load tile entity on builder from saved NBT.  Did a pack change?");
                        InterfaceManager.coreInterface.logError(e.getMessage());
                        this.f_58857_.m_7471_(this.f_58858_, false);
                    }
                }
            }
            if (this.f_58857_.f_46443_) {
                if (this.needDataFromServer) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityCSHandshakeClient(InterfaceManager.clientInterface.getClientPlayer(), this));
                    this.needDataFromServer = false;
                }
            } else if (!this.playersRequestingData.isEmpty()) {
                for (IWrapperPlayer player : this.playersRequestingData) {
                    IWrapperNBT data = InterfaceManager.coreInterface.getNewNBTWrapper();
                    this.m_183515_(((WrapperNBT)data).tag);
                    player.sendPacket(new PacketEntityCSHandshakeServer(this, data));
                }
                this.playersRequestingData.clear();
            }
        }
    }

    protected void setTileEntity(ATileEntityBase<?> tile) {
        this.tileEntity = tile;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.tileEntity != null) {
            this.tileEntity.remove();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.tileEntity != null && this.tileEntity.isValid) {
            this.m_7651_();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lastLoadedNBT = tag;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.tileEntity != null) {
            this.tileEntity.save(new WrapperNBT(tag));
        } else if (this.lastLoadedNBT != null) {
            tag = this.lastLoadedNBT;
        }
    }
}

